PosX = 0
PosY = 0

FakeArena = {x = 320, y = 90, rotation = 0}

Arena.MoveTo(1000, 500, true, true)
FakeArena1 = CreateSprite("Rotatory Arena Pixel","BelowPlayer")
FakeArena2 = CreateSprite("Rotatory Arena Pixel","BelowPlayer")
FakeArena2.color = {0,0,0}
FakeArena1.Scale(Arena.width + 10, Arena.height + 10)
FakeArena2.Scale(Arena.width, Arena.height)
FakeArena1.MoveTo(FakeArena.x, FakeArena.y + FakeArena1.yscale/2)
FakeArena2.MoveTo(FakeArena1.x, FakeArena1.y)
FakeArena1.rotation = FakeArena.rotation
FakeArena2.rotation = FakeArena1.rotation

Player.SetControlOverride(true)
SetPPCollision(true)

function FakeArena.Update()
	if FakeArena1 and FakeArena2 then
		if not state or (state and state == 0) then
			if Input.Down > 0 and Input.Up == 0 then
				if Input.Cancel > 0 then
					PosY = PosY - 1
				else
					PosY = PosY - 2
				end
			elseif Input.Up > 0 and Input.Down == 0 then
				if Input.Cancel > 0 then
					PosY = PosY + 1
				else
					PosY = PosY + 2
				end
			end
			if Input.Left > 0 and Input.Right == 0 then
				if Input.Cancel > 0 then
					PosX = PosX - 1
				else
					PosX = PosX - 2
				end
			elseif Input.Right > 0 and Input.Left == 0 then
				if Input.Cancel > 0 then
					PosX = PosX + 1
				else
					PosX = PosX + 2
				end
			end
		end
		FakeArena1.rotation = FakeArena.rotation
		FakeArena2.rotation = FakeArena1.rotation
		FakeArena1.Scale(Arena.width + 10, Arena.height + 10)
		FakeArena2.Scale(Arena.width, Arena.height)
		FakeArena1.MoveTo(FakeArena.x, FakeArena.y + FakeArena1.yscale/2)
		FakeArena2.MoveTo(FakeArena1.x, FakeArena1.y)
		while PosX*math.cos(math.rad(-FakeArena2.rotation)) - PosY*math.sin(math.rad(-FakeArena2.rotation)) > Arena.width/2 - 8 do
			PosX = PosX - math.cos(math.rad(FakeArena2.rotation))
			PosY = PosY - math.sin(math.rad(FakeArena2.rotation))
		end
		while PosX*math.cos(math.rad(-FakeArena2.rotation)) - PosY*math.sin(math.rad(-FakeArena2.rotation)) < -Arena.width/2 + 8 do
			PosX = PosX + math.cos(math.rad(FakeArena2.rotation))
			PosY = PosY + math.sin(math.rad(FakeArena2.rotation))
		end
		while PosY*math.cos(math.rad(-FakeArena2.rotation)) + PosX*math.sin(math.rad(-FakeArena2.rotation)) > Arena.height/2 - 8 do
			PosX = PosX + math.sin(math.rad(FakeArena2.rotation))
			PosY = PosY - math.cos(math.rad(FakeArena2.rotation))
		end
		while PosY*math.cos(math.rad(-FakeArena2.rotation)) + PosX*math.sin(math.rad(-FakeArena2.rotation)) < -Arena.height/2 + 8 do
			PosX = PosX - math.sin(math.rad(FakeArena2.rotation))
			PosY = PosY + math.cos(math.rad(FakeArena2.rotation))
		end
		Player.MoveToAbs(FakeArena1.x + PosX, FakeArena1.y + PosY, true)
	end
end

function FakeArena.Resize(X, Y, withPlayer)
	if withPlayer then
		PosX = PosX - (Arena.width - X)/2
		PosY = PosY - (Arena.height - Y)/2
	end
	Arena.Resize(X, Y)
end

function FakeArena.ResizeImmediate(X, Y, withPlayer)
	if withPlayer then
		PosX = PosX - (Arena.width - X)/2
		PosY = PosY - (Arena.height - Y)/2
	end
	Arena.ResizeImmediate(X, Y)
end

function FakeArena.MoveTo(X, Y, withPlayer)
	if not withPlayer then
		PosX = PosX + (FakeArena.x - X)
		PosY = PosY + (FakeArena.y - Y)
	end
	FakeArena.x = X
	FakeArena.y = Y
end

function FakeArena.Remove() --Put this before the wave ends.
	if FakeArena1 then
		FakeArena1.Remove()
		FakeArena1 = nil
	end
	if FakeArena2 then
		FakeArena2.Remove()
		FakeArena2 = nil
	end
end